(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      2953,        104]*)
(*NotebookOutlinePosition[      3825,        132]*)
(*  CellTagsIndexPosition[      3781,        128]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Clear[\"global`*\"]", "Section",
  Evaluatable->True,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["Clear[\"global`*\"]", "Text"],

Cell[CellGroupData[{

Cell["Air Pressure at a Volcanic Lake", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(latitude = 10.2; \nelevation = 2250; \n
    airtsl = 27 - 0.008\ latitude\^2; \n\(airtc = airtsl - 0.006\ elevation; 
    \)\), 
    \(\(raintc = airtc; \)\)}], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Temperature conversions to kelvin", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(raintemp = raintc + 273; \)\), 
    \(\(airtemp = airtc + 273; \)\)}], "Input",
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Air Pressure at Volcano", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(airpresspascal = 
      101300\ \((\(airtemp - .0065\ elevation\)\/airtemp)\)\^5.2586; \)\), 
    \(airpressmbar = airpresspascal\/100\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(768.405001906300633`\)], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 800}, {0, 580}},
AutoGeneratedPackage->Automatic,
WindowSize->{520, 485},
WindowMargins->{{44, Automatic}, {Automatic, 1}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 113, 3, 50, "Section",
  InitializationCell->True],
Cell[1847, 56, 35, 0, 30, "Text"],

Cell[CellGroupData[{
Cell[1907, 60, 101, 2, 45, "Subsection"],
Cell[2011, 64, 216, 5, 88, "Input"],

Cell[CellGroupData[{
Cell[2252, 73, 106, 2, 40, "Subsubsection"],
Cell[2361, 77, 128, 3, 41, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2526, 85, 96, 2, 40, "Subsubsection"],

Cell[CellGroupData[{
Cell[2647, 91, 197, 4, 96, "Input"],
Cell[2847, 97, 54, 1, 26, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

