(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     15239,        530]*)
(*NotebookOutlinePosition[     16198,        561]*)
(*  CellTagsIndexPosition[     16154,        557]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[
"Perfect Mixing\nHydrothermal Steady State\nCrater Lake Model\n"], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->20,
  FontWeight->"Bold",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontVariations->{"Underline"->True,
  "Outline"->False,
  "Shadow"->False}],

Cell[TextData[{
  StyleBox["Red text indicates input parameters (windspeed assumed the same \
for all lakes because there is no field observations published anywhere, but \
this is wrong; catchment area assumed as 1.5 times lake area where no data is \
available)\n",
    FontColor->RGBColor[1, 0, 0]],
  StyleBox["magenta text indicates output values",
    FontColor->RGBColor[1, 0, 1]]
}], "Text"],

Cell[CellGroupData[{

Cell["Clear[\"global`*\"]", "Section",
  Evaluatable->True,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData["Clear[\"global`*\"]"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "The relation between SO",
  StyleBox["2",
    FontSize->12,
    FontVariations->{"CompatibilityType"->"Subscript"}],
  " flux and gas temperature"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(gastemp[so2_ /; so2 < 25] := 673;\)\), "\n", 
    \(\(gastemp[so2_ /; so2 \[GreaterEqual] 25] := 1073;\)\)}], "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Determination of the distribution of input mass", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{\(so2molday[so2_] := \(10\^6\ so2\)\/64.07\), "\n", 
    RowBox[{\(totlmolday[so2_]\), ":=", 
      FractionBox[\(so2molday[so2]\), 
        StyleBox["0.02",
          FontColor->RGBColor[1, 0, 0]]]}], "\n", 
    RowBox[{\(co2molday[so2_]\), ":=", 
      RowBox[{
        StyleBox["0.05",
          FontColor->RGBColor[1, 0, 0]], " ", \(totlmolday[so2]\)}]}], "\n", 
    RowBox[{\(h2omolday[so2_]\), ":=", 
      RowBox[{
        StyleBox["0.93",
          FontColor->RGBColor[1, 0, 0]], 
        " ", \(totlmolday[so2]\)}]}]}], "Input",
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Constants"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Lake and atmosphere characteristics"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    StyleBox[\(latitude = 6.44;\),
      FontColor->RGBColor[1, 0, 0]], "\n", 
    StyleBox[\(elevation = 1080;\),
      FontColor->RGBColor[1, 0, 
      0]], "\n", \(airtsl = 27 - 0.008\ latitude\^2;\), "\n", 
    StyleBox[\(airtc = airtsl - 0.006\ elevation\),
      FontColor->RGBColor[1, 0, 1]], "\n", \(raintc = airtc;\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(20.188211199999998`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Temperature conversions to kelvin", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(raintemp = raintc + 273;\)\), "\n", 
    \(\(airtemp = airtc + 273;\)\)}], "Input",
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Air Pressure at Volcano"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(airpresspascal = 
        101300\ \((\(airtemp -  .0065\ elevation\)\/airtemp)\)\^5.2586;\)\), \
"\n", 
    \(airpressmbar = airpresspascal\/100\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(891.7889272715245`\)], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Basin characteristics"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    RowBox[{
      StyleBox[\(lakeradius = 709.18\),
        FontColor->RGBColor[1, 0, 0]], ";"}], "\n", 
    StyleBox[\(windspeed = 2.5;\),
      FontColor->RGBColor[1, 0, 0]], "\n", 
    StyleBox[\(catchradius = 1.5\ lakeradius;\),
      FontColor->RGBColor[1, 0, 
      0]], "\n", \(catcharea = 
        3.141592654\ catchradius\^2;\), "\n", \(lakearea = 
        3.141592654\ lakeradius\^2;\)}], "Input",
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Determine the precipitation rate (m/yr)"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(f[p_] := p\/365\), "\n", 
    \(meth2oday[p_] := catcharea\ f[p]\)}], "Input",
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Heat influx algorithm"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Water vapor"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(qwjday[x_, so2_] := 
        38.75\ \((gastemp[so2] - 372.8)\)\ h2omolday[so2] + 
          75.5\ \((372.8 - x)\)\ h2omolday[so2] + 
          40866\ h2omolday[so2];\)\)], "Input",
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Carbon dioxide gas"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(b[x_] := 
      87.82\ x - \(2.6442\  .5\ x\^2\)\/10\^3 - 998.86\ 2\ x\^ .5 - 
        706410\/x\), "\n", 
    \(qgcb[gastemp_] := 
      87.82\ gastemp - \(2.6442\  .5\ gastemp\^2\)\/10\^3 - 
        998.86\ 2\ gastemp\^ .5 - 706410\/gastemp\), "\n", 
    \(qgcc[x_, gastemp_] := qgcb[gastemp] - b[x]\), "\n", 
    \(qgcjday[x_, so2_] := qgcc[x, gastemp[so2]]\ co2molday[so2]\)}], "Input",\

  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Sulfur dioxide gas"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(c[x_] := 
      86.219\ x - \(4.3073\  .5\ x\^2\)\/10\^3 - 886.46\ 2\ x\^ .5 - 
        557690\/x\), "\n", 
    \(qgsb[gastemp_] := 
      86.219\ gastemp - \(4.3073\  .5\ gastemp\^2\)\/10\^3 - 
        886.46\ 2\ gastemp\^ .5 - 557690\/gastemp\), "\n", 
    \(qgsc[x_, gastemp_] := qgsb[gastemp] - c[x]\), "\n", 
    \(qgsjday[x_, so2_] := qgsc[x, gastemp[so2]]\ so2molday[so2]\)}], "Input",\

  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Net shortwave radiation"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{\(solarflux = 
        185 + 5.9\ latitude - 0.22\ latitude\^2 + 
          0.00167\ latitude\^3;\), "\n", \(qsunjday = 
        solarflux\ lakearea\ 86400;\), "\n", 
    StyleBox[\(qsunmw = qsunjday\/\(10\^6\ 86400\)\),
      FontColor->RGBColor[1, 0, 1]]}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(338.6266792580549`\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Longwave radiation influx"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{\(clouds = 
        5.1946 - 0.23227\ latitude + 
          0.0067727\ latitude\^2 - \(4.9495\ latitude\^3\)\/10\^5;\), "\n", \
\(radina = 208 + 6\ airtc;\), "\n", \(lradinjday = 
        radina\ \((1 + 0.0034\ clouds\^2)\)\ lakearea\ 86400;\), "\n", 
    StyleBox[\(lradinmw = lradinjday\/\(10\^6\ 86400\)\),
      FontColor->RGBColor[1, 0, 1]]}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(547.8482417711015`\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Summation of influx terms"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(heatinjday[x_, so2_] := 
        qwjday[x, so2] + qgcjday[x, so2] + qgsjday[x, so2] + qsunjday + 
          lradinjday;\)\), "\n", 
    \(gasinjday[x_, so2_] := 
      qwjday[x, so2] + qgcjday[x, so2] + qgsjday[x, so2]\), "\n", 
    \(\(volgasmw[x_, so2_] := 
        gasinjday[x, so2]\/\(10\^6\ 86400\);\)\), "\n", 
    \(\(heatmw[x_, so2_] := 
        heatinjday[x, so2]\/\(10\^6\ 86400\);\)\)}], "Input",
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Heat outflux algorithm"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Net radiative heat loss"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(radoutjday[x_] := \(5.67\ x\^4\ lakearea\ 86400\)\/10\^8\)], "Input",
  AspectRatioFixed->True,
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontVariations->{"Underline"->False,
  "Outline"->False,
  "Shadow"->False}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Evaporation outflux (by wind and buoyancy)"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(d[x_] := \(-0.00019899\)\ x\^2 + 0.179064\ x - 32.23339;\)\), "\n", 
    \(\(e0[x_] := E\^d[x];\)\), "\n", 
    \(\(virtlaktemp[x_] := 
        x\/\(1 - \(0.378\ e0[x]\)\/airpressmbar\);\)\), "\n", 
    \(\(ewa = \(-0.00019899\)\ airtemp\^2 + 0.179064\ airtemp - 
          32.23339;\)\), "\n", 
    \(\(ea = E\^ewa;\)\), "\n", 
    \(\(virtairtemp = 
        airtemp\/\(1 - \(0.378\ ea\)\/airpressmbar\);\)\), "\n", 
    \(evapjday[
        x_] := \((1\/3\ 2.7\ \((virtlaktemp[x] - virtairtemp)\)\^1 + 
            3.2\ windspeed)\)\ \((e0[x] - ea)\)\ lakearea\ 86400\), "\n", 
    \(evapmolday[x_] := evapjday[x]\/40866\), "\n", 
    \(evapdis[x_] := evapmolday[x]\/55555.6\)}], "Input",
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Rain water heating term"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(heatrainjday[x_, 
          p_ /; raintc > 0] := \((x - raintemp)\)\ 75.42\ 55555.6\ meth2oday[
            p];\)\), "\n", 
    \(\(heatrainjday[x_, 
          p_ /; raintc \[LessEqual] 
              0] := \((x - 273)\)\ 75.42\ 55555.6\ meth2oday[p] + 
          6000\ 55555.6\ lakearea\ f[p];\)\)}], "Input",
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Conductive loss (via Bowen ratio)"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(condjday[
        x_] := \(0.61\ evapjday[x]\ \((x - airtemp)\)\)\/\(e0[x] - ea\)\)], \
"Input",
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Summation of outflux terms"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(heatoutjday[x_, p_] := 
      radoutjday[x] + evapjday[x] + heatrainjday[x, p] + 
        condjday[x]\), "\n", 
    \(radoutmw[x_] := radoutjday[x]\/\(10\^6\ 86400\)\), "\n", 
    \(evapmw[x_] := evapjday[x]\/\(10\^6\ 86400\)\), "\n", 
    \(heatrainmw[x_, p] := heatrainjday[x, p]\/\(10\^6\ 86400\)\), "\n", 
    \(condmw[x_] := condjday[x]\/\(10\^6\ 86400\)\), "\n", 
    \(netlradmw[x_] := radoutmw[x] - lradinmw\)}], "Input",
  AspectRatioFixed->True]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Apply mass conservation for heat and water"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Water conservation"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(watgain[p_, so2_] := 
      meth2oday[p] + \(18\ h2omolday[so2]\)\/10\^6\)], "Input",
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Solve equations"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"data", "=", 
        RowBox[{"Table", "[", 
          RowBox[{
            RowBox[{
              RowBox[{"{", 
                
                StyleBox[\(so2, x, p, meth2oday[p], volgasmw[x, so2], 
                  netlradmw[x], evapmw[x], heatrainmw[x, p], condmw[x]\),
                  FontColor->RGBColor[1, 0, 1]], "}"}], 
              "/.", \(FindRoot[{heatoutjday[x, p] == heatinjday[x, so2], 
                  watgain[p, so2] == evapdis[x]}, {p,  .1}, {x, 295}, 
                AccuracyGoal \[Rule] 3]\)}], ",", \({so2, 380, 381, 1}\)}], 
          "]"}]}], ";"}]], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(FindRoot::"cvnwt" \(\(:\)\(\ \)\) 
      "Newton's method failed to converge to the prescribed accuracy after \!\
\(15\) iterations."\)], "Message"],

Cell[BoxData[
    \(FindRoot::"cvnwt" \(\(:\)\(\ \)\) 
      "Newton's method failed to converge to the prescribed accuracy after \!\
\(15\) iterations."\)], "Message"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Output Results"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[SetAccuracy[data, 3], TableSpacing \[Rule] {0, 4}]\)], "Input",\

  AspectRatioFixed->True],

Cell[BoxData[
    TagBox[GridBox[{
          {"380.`5.5798", "299.99668518265906`5.4771", 
            "0.66204868284742`2.8209", "6448.25807829402947`6.8094", 
            "243.6398636203574`5.3867", "177.77588471659169`5.2499", 
            "299.88699122045983`5.477", "2.12908412151195`3.3282", 
            "102.47458281984997`5.0106"},
          {"381.`5.5809", "300.0026103581389`5.4771", 
            "0.66244486647129`2.8211", "6452.11684928672003`6.8097", 
            "244.27953521538186`5.3879", "177.8332130521668`5.25", 
            "300.33166703587932`5.4776", "2.13221218531596`3.3288", 
            "102.60912220007566`5.0112"}
          },
        RowSpacings->0,
        ColumnSpacings->4,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$, TableSpacing -> {0, 4}]]]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.1 for Macintosh",
ScreenRectangle->{{0, 1280}, {0, 1002}},
AutoGeneratedPackage->Automatic,
WindowToolbars->{"RulerBar", "EditBar"},
CellGrouping->Automatic,
WindowSize->{947, 660},
WindowMargins->{{160, Automatic}, {Automatic, 15}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1727, 52, 301, 10, 188, "Title",
  Evaluatable->False],
Cell[2031, 64, 399, 8, 68, "Text"],

Cell[CellGroupData[{
Cell[2455, 76, 113, 3, 56, "Section",
  Evaluatable->True,
  InitializationCell->True],
Cell[2571, 81, 93, 2, 32, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[2701, 88, 228, 8, 62, "Section",
  Evaluatable->False],
Cell[2932, 98, 167, 3, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[3136, 106, 114, 2, 36, "Section",
  Evaluatable->False],
Cell[3253, 110, 577, 14, 113, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3867, 129, 86, 2, 56, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3978, 135, 115, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4118, 141, 378, 8, 93, "Input"],
Cell[4499, 151, 53, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4589, 157, 106, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[4698, 161, 132, 3, 43, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4867, 169, 106, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4998, 175, 207, 5, 79, "Input"],
Cell[5208, 182, 52, 1, 27, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5321, 190, 101, 2, 46, "Subsection",
  Evaluatable->False],
Cell[5425, 194, 449, 11, 95, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5911, 210, 119, 2, 46, "Subsection",
  Evaluatable->False],
Cell[6033, 214, 125, 3, 57, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6207, 223, 98, 2, 56, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6330, 229, 91, 2, 46, "Subsection",
  Evaluatable->False],
Cell[6424, 233, 228, 5, 43, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6689, 243, 98, 2, 46, "Subsection",
  Evaluatable->False],
Cell[6790, 247, 439, 10, 119, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7266, 262, 98, 2, 46, "Subsection",
  Evaluatable->False],
Cell[7367, 266, 441, 10, 119, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7845, 281, 103, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7973, 287, 308, 6, 78, "Input"],
Cell[8284, 295, 52, 1, 27, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8385, 302, 105, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8515, 308, 397, 7, 116, "Input"],
Cell[8915, 317, 52, 1, 27, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9016, 324, 105, 2, 46, "Subsection",
  Evaluatable->False],
Cell[9124, 328, 456, 10, 110, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9629, 344, 99, 2, 56, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9753, 350, 103, 2, 46, "Subsection",
  Evaluatable->False],
Cell[9859, 354, 264, 8, 45, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10160, 367, 122, 2, 46, "Subsection",
  Evaluatable->False],
Cell[10285, 371, 738, 15, 292, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11060, 391, 103, 2, 46, "Subsection",
  Evaluatable->False],
Cell[11166, 395, 359, 8, 75, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11562, 408, 113, 2, 46, "Subsection",
  Evaluatable->False],
Cell[11678, 412, 142, 4, 44, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11857, 421, 106, 2, 46, "Subsection",
  Evaluatable->False],
Cell[11966, 425, 476, 9, 196, "Input"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[12491, 440, 119, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12635, 446, 98, 2, 46, "Subsection",
  Evaluatable->False],
Cell[12736, 450, 131, 3, 42, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12904, 458, 95, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13024, 464, 656, 15, 75, "Input"],
Cell[13683, 481, 168, 3, 21, "Message"],
Cell[13854, 486, 168, 3, 21, "Message"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[14071, 495, 94, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[14190, 501, 121, 3, 27, "Input"],
Cell[14314, 506, 873, 18, 35, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

