(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     22229,        652]*)
(*NotebookOutlinePosition[     23388,        688]*)
(*  CellTagsIndexPosition[     23344,        684]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[
"Perfect Mixing\nHydrothermal Steady State\nCrater Lake Model\n"], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->20,
  FontWeight->"Bold",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontVariations->{"Underline"->True,
  "Outline"->False,
  "Shadow"->False}],

Cell[CellGroupData[{

Cell["Clear[\"global`*\"]", "Section",
  Evaluatable->True,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData["Clear[\"global`*\"]"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The relation between SO",
  StyleBox["2",
    FontSize->12,
    FontVariations->{"CompatibilityType"->"Subscript"}],
  " flux and gas temperature"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(gastemp[so2_ /; so2 < 25] := 673; \)\), 
    \(\(gastemp[so2_ /; so2 \[GreaterEqual] 25] := 1073; \)\)}], "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Determination of the distribution of input mass"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(so2molday[so2_] := \(10\^6\ so2\)\/64.07\), 
    \(totlmolday[so2_] := so2molday[so2]\/0.02\), 
    \(co2molday[so2_] := 0.05\ totlmolday[so2]\), 
    \(h2omolday[so2_] := 0.93\ totlmolday[so2]\)}], "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Constants"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Lake and atmosphere characteristics"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(latitude = 10.2; \nelevation = 2250; \n
    airtsl = 27 - 0.008\ latitude\^2; \n\(airtc = airtsl - 0.006\ elevation; 
    \)\), 
    \(\(raintc = airtc; \)\)}], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Temperature conversions to kelvin"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(raintemp = raintc + 273; \)\), 
    \(\(airtemp = airtc + 273; \)\)}], "Input",
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Air Pressure at Volcano"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(airpresspascal = 
      101300\ \((\(airtemp - .0065\ elevation\)\/airtemp)\)\^5.2586; \)\), 
    \(airpressmbar = airpresspascal\/100\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(768.405001906300633`\)], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Basin characteristics"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(lakeradius = 50; \)\), 
    \(\(windspeed = 2.5; \)\), 
    \(\(catchradius = 1.5\ lakeradius; \)\), 
    \(\(catcharea = 3.141592654\ catchradius\^2; \)\), 
    \(\(lakearea = 3.141592654\ lakeradius\^2; \)\)}], "Input",
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Determine the precipitation rate (m/yr)"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(f[p_] := p\/365\), 
    \(meth2oday[p_] := catcharea\ f[p]\)}], "Input",
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Heat influx algorithm"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Water vapor"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(qwjday[x_, so2_] := 
      38.75\ \((gastemp[so2] - 372.8)\)\ h2omolday[so2] + 
        75.5\ \((372.8 - x)\)\ h2omolday[so2] + 40866\ h2omolday[so2]; \)\)], 
  "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Carbon dioxide gas"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(b[x_] := 
      87.82\ x - \(2.6442\ .5\ x\^2\)\/10\^3 - 998.86\ 2\ x\^.5 - 706410\/x\),
   
    \(qgcb[gastemp_] := 
      87.82\ gastemp - \(2.6442\ .5\ gastemp\^2\)\/10\^3 - 
        998.86\ 2\ gastemp\^.5 - 706410\/gastemp\), 
    \(qgcc[x_, gastemp_] := qgcb[gastemp] - b[x]\), 
    \(qgcjday[x_, so2_] := qgcc[x, gastemp[so2]]\ co2molday[so2]\)}], "Input",\

  AspectRatioFixed->True],

Cell[TextData[
"General::spell1: Possible spelling error: new symbol name \"qgcc\" is \
similar to existing symbol \n    \"qgcb\"."], "Message",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Palatino"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Sulfur dioxide gas"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(c[x_] := 
      86.219\ x - \(4.3073\ .5\ x\^2\)\/10\^3 - 886.46\ 2\ x\^.5 - 
        557690\/x\), 
    \(qgsb[gastemp_] := 
      86.219\ gastemp - \(4.3073\ .5\ gastemp\^2\)\/10\^3 - 
        886.46\ 2\ gastemp\^.5 - 557690\/gastemp\), 
    \(qgsc[x_, gastemp_] := qgsb[gastemp] - c[x]\), 
    \(qgsjday[x_, so2_] := qgsc[x, gastemp[so2]]\ so2molday[so2]\)}], "Input",\

  AspectRatioFixed->True],

Cell[TextData[
"General::spell1: Possible spelling error: new symbol name \"qgsb\" is \
similar to existing symbol \n    \"qgcb\"."], "Message",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Palatino"],

Cell[TextData[
"General::spell: Possible spelling error: new symbol name \"qgsc\" is similar \
to existing symbols \n    {qgcc, qgsb}."], "Message",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Palatino"],

Cell[TextData[
"General::spell1: Possible spelling error: new symbol name \"qgsjday\" is \
similar to existing symbol \n    \"qgcjday\"."], "Message",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Palatino"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Net shortwave radiation"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(solarflux = 
      185 + 5.9\ latitude - 0.22\ latitude\^2 + 0.00167\ latitude\^3; \)\), 
    \(\(qsunjday = solarflux\ lakearea\ 86400; \)\), 
    \(qsunmw = qsunjday\/\(10\^6\ 86400\)\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(1.5177888624675888\ 10\^11\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Palatino"],

Cell[BoxData[
    \(1.75670007230045\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Palatino"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Longwave radiation influx"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(clouds = 
      5.1946 - 0.23227\ latitude + 0.0067727\ latitude\^2 - 
        \(4.9495\ latitude\^3\)\/10\^5; \)\), 
    \(\(radina = 208 + 6\ airtc; \)\), 
    \(\(lradinjday = radina\ \((1 + 0.0034\ clouds\^2)\)\ lakearea\ 86400; 
    \)\), 
    \(\(lradinmw = lradinjday\/\(10\^6\ 86400\); \)\)}], "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Summation of influx terms"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(heatinjday[x_, so2_] := 
      qwjday[x, so2] + qgcjday[x, so2] + qgsjday[x, so2] + qsunjday + 
        lradinjday; \)\), 
    \(gasinjday[x_, so2_] := 
      qwjday[x, so2] + qgcjday[x, so2] + qgsjday[x, so2]\), 
    \(\(volgasmw[x_, so2_] := gasinjday[x, so2]\/\(10\^6\ 86400\); \)\), 
    \(\(heatmw[x_, so2_] := heatinjday[x, so2]\/\(10\^6\ 86400\); \)\)}], 
  "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Heat outflux algorithm"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Net radiative heat loss"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(radoutjday[x_] := \(5.67\ x\^4\ lakearea\ 86400\)\/10\^8\)], "Input",
  AspectRatioFixed->True,
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontVariations->{"Underline"->False,
  "Outline"->False,
  "Shadow"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Evaporation outflux (by wind and buoyancy)"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(d[x_] := \(-0.00019899\)\ x\^2 + 0.179064\ x - 32.23339; \)\), 
    \(\(e0[x_] := E\^d[x]; \)\), 
    \(\(virtlaktemp[x_] := x\/\(1 - \(0.378\ e0[x]\)\/airpressmbar\); \)\), 
    \(\(ewa = \(-0.00019899\)\ airtemp\^2 + 0.179064\ airtemp - 32.23339; 
    \)\), 
    \(\(ea = E\^ewa; \)\), 
    \(\(virtairtemp = airtemp\/\(1 - \(0.378\ ea\)\/airpressmbar\); \)\), 
    \(evapjday[x_] := 
      \((1\/3\ 2.7\ \((virtlaktemp[x] - virtairtemp)\)\^1 + 3.2\ windspeed)
          \)\ \((e0[x] - ea)\)\ lakearea\ 86400\), 
    \(evapmolday[x_] := evapjday[x]\/40866\), 
    \(evapdis[x_] := evapmolday[x]\/55555.6\)}], "Input",
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Rain water heating term"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(heatrainjday[x_, p_ /; raintc > 0] := 
      \((x - raintemp)\)\ 75.42\ 55555.6\ meth2oday[p]; \)\), 
    \(\(heatrainjday[x_, p_ /; raintc \[LessEqual] 0] := 
      \((x - 273)\)\ 75.42\ 55555.6\ meth2oday[p] + 
        6000\ 55555.6\ lakearea\ f[p]; \)\)}], "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Conductive loss (via Bowen ratio)"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(condjday[x_] := 
      \(0.61\ evapjday[x]\ \((x - airtemp)\)\)\/\(e0[x] - ea\)\)], "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Summation of outflux terms"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(heatoutjday[x_, p_] := 
      radoutjday[x] + evapjday[x] + heatrainjday[x, p] + condjday[x]\), 
    \(radoutmw[x_] := radoutjday[x]\/\(10\^6\ 86400\)\), 
    \(evapmw[x_] := evapjday[x]\/\(10\^6\ 86400\)\), 
    \(heatrainmw[x_, p] := heatrainjday[x, p]\/\(10\^6\ 86400\)\), 
    \(condmw[x_] := condjday[x]\/\(10\^6\ 86400\)\), 
    \(netlradmw[x_] := radoutmw[x] - lradinmw\)}], "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Apply mass conservation for heat and water"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Water conservation"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(watgain[p_, so2_] := meth2oday[p] + \(18\ h2omolday[so2]\)\/10\^6\)], 
  "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Solve equations"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(data = 
      Table[{so2, x, p, volgasmw[x, so2], netlradmw[x], evapmw[x], 
            heatrainmw[x, p], condmw[x]} /. 
          FindRoot[{heatoutjday[x, p] == heatinjday[x, so2], 
              watgain[p, so2] == evapdis[x]}, {p, .1}, {x, 295}, 
            AccuracyGoal \[Rule] 5], {so2, 0, 4, 1}]; \)\)], "Input",
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Output Results"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[SetAccuracy[data, 5], TableSpacing \[Rule] {0, 4}]\)], "Input",\

  AspectRatioFixed->True],

Cell[BoxData[
    TagBox[GridBox[{
          {\(SetAccuracy[0, 5.000000001400095884]\), "302.77002", "0.61659", 
            \(SetAccuracy[0, 5.000000001400095884]\), "0.75446", "0.78442", 
            "0.00517", "0.21265"},
          {"1.00000", "303.77363", "0.62627", "0.49516", "0.80433", "1.14002",
             "0.00673", "0.30079"},
          {"2.00000", "304.63928", "0.64149", "0.98918", "0.84774", "1.50266",
             "0.00819", "0.38729"},
          {"3.00000", "305.40598", "0.66089", "1.48226", "0.88649", "1.87062",
             "0.00963", "0.47222"},
          {"4.00000", "306.09741", "0.68361", "1.97453", "0.92170", "2.24281",
             "0.01107", "0.55565"},
          {"5.00000", "306.72923", "0.70908", "2.46608", "0.95408", "2.61848",
             "0.01254", "0.63769"},
          {"6.00000", "307.31240", "0.73686", "2.95699", "0.98414", "2.99711",
             "0.01404", "0.71841"},
          {"7.00000", "307.85496", "0.76664", "3.44732", "1.01226", "3.37828",
             "0.01558", "0.79791"},
          {"8.00000", "308.36299", "0.79817", "3.93712", "1.03873", "3.76167",
             "0.01717", "0.87625"},
          {"9.00000", "308.84123", "0.83125", "4.42643", "1.06377", "4.14703",
             "0.01882", "0.95351"},
          {"10.00000", "309.29344", "0.86572", "4.91528", "1.08755", 
            "4.53416", "0.02052", "1.02975"},
          {"11.00000", "309.72269", "0.90144", "5.40370", "1.11022", 
            "4.92288", "0.02227", "1.10502"},
          {"12.00000", "310.13149", "0.93830", "5.89171", "1.13190", 
            "5.31305", "0.02408", "1.17938"},
          {"13.00000", "310.52195", "0.97621", "6.37934", "1.15268", 
            "5.70455", "0.02595", "1.25286"},
          {"14.00000", "310.89584", "1.01507", "6.86661", "1.17266", 
            "6.09727", "0.02787", "1.32551"},
          {"15.00000", "311.25469", "1.05481", "7.35354", "1.19190", 
            "6.49112", "0.02985", "1.39737"},
          {"16.00000", "311.59980", "1.09538", "7.84014", "1.21047", 
            "6.88601", "0.03189", "1.46847"},
          {"17.00000", "311.93230", "1.13672", "8.32643", "1.22842", 
            "7.28188", "0.03398", "1.53885"},
          {"18.00000", "312.25319", "1.17877", "8.81242", "1.24579", 
            "7.67865", "0.03613", "1.60854"},
          {"19.00000", "312.56334", "1.22150", "9.29811", "1.26264", 
            "8.07629", "0.03833", "1.67756"},
          {"20.00000", "312.86353", "1.26485", "9.78353", "1.27899", 
            "8.47472", "0.04058", "1.74595"},
          {"21.00000", "313.15444", "1.30880", "10.26869", "1.29488", 
            "8.87391", "0.04288", "1.81371"},
          {"22.00000", "313.43669", "1.35331", "10.75358", "1.31034", 
            "9.27382", "0.04524", "1.88089"},
          {"23.00000", "313.71084", "1.39835", "11.23823", "1.32540", 
            "9.67440", "0.04764", "1.94749"},
          {"24.00000", "313.97738", "1.44390", "11.72264", "1.34008", 
            "10.07562", "0.05010", "2.01354"},
          {"25.00000", "315.92763", "3.77884", "15.76670", "1.44861", 
            "13.38941", "0.14841", "2.53696"},
          {"26.00000", "316.20183", "3.92014", "16.39267", "1.46403", 
            "13.91245", "0.15649", "2.61641"},
          {"27.00000", "316.46879", "4.06196", "17.01841", "1.47908", 
            "14.43615", "0.16469", "2.69518"},
          {"28.00000", "316.72891", "4.20428", "17.64393", "1.49379", 
            "14.96049", "0.17303", "2.77332"},
          {"29.00000", "316.98257", "4.34707", "18.26922", "1.50816", 
            "15.48544", "0.18150", "2.85083"},
          {"30.00000", "317.23010", "4.49032", "18.89431", "1.52222", 
            "16.01096", "0.19009", "2.92774"},
          {"31.00000", "317.47183", "4.63401", "19.51918", "1.53598", 
            "16.53703", "0.19880", "3.00406"},
          {"32.00000", "317.70802", "4.77811", "20.14385", "1.54946", 
            "17.06364", "0.20763", "3.07982"},
          {"33.00000", "317.93897", "4.92261", "20.76833", "1.56267", 
            "17.59075", "0.21658", "3.15503"},
          {"34.00000", "318.16490", "5.06749", "21.39261", "1.57562", 
            "18.11834", "0.22564", "3.22971"}
          },
        RowSpacings->0,
        ColumnSpacings->4,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #, TableSpacing -> {0, 4}]&)]], "Output",
  Evaluatable->False,
  LineSpacing->{1.25, 0},
  AspectRatioFixed->True,
  FontFamily->"Palatino"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(SetAccuracy[0, 5.000000001400095884]\), "302.77002", "0.61659", 
            \(SetAccuracy[0, 5.000000001400095884]\), "0.75446", "0.78442", 
            "0.00517", "0.21265"},
          {"1.00000", "303.77363", "0.62627", "0.49516", "0.80433", "1.14002",
             "0.00673", "0.30079"},
          {"2.00000", "304.63928", "0.64149", "0.98918", "0.84774", "1.50266",
             "0.00819", "0.38729"},
          {"3.00000", "305.40598", "0.66089", "1.48226", "0.88649", "1.87062",
             "0.00963", "0.47222"},
          {"4.00000", "306.09741", "0.68361", "1.97453", "0.92170", "2.24281",
             "0.01107", "0.55565"},
          {"5.00000", "306.72923", "0.70908", "2.46608", "0.95408", "2.61848",
             "0.01254", "0.63769"},
          {"6.00000", "307.31240", "0.73686", "2.95699", "0.98414", "2.99711",
             "0.01404", "0.71841"},
          {"7.00000", "307.85496", "0.76664", "3.44732", "1.01226", "3.37828",
             "0.01558", "0.79791"},
          {"8.00000", "308.36299", "0.79817", "3.93712", "1.03873", "3.76167",
             "0.01717", "0.87625"},
          {"9.00000", "308.84123", "0.83125", "4.42643", "1.06377", "4.14703",
             "0.01882", "0.95351"},
          {"10.00000", "309.29344", "0.86572", "4.91528", "1.08755", 
            "4.53416", "0.02052", "1.02975"},
          {"11.00000", "309.72269", "0.90144", "5.40370", "1.11022", 
            "4.92288", "0.02227", "1.10502"},
          {"12.00000", "310.13149", "0.93830", "5.89171", "1.13190", 
            "5.31305", "0.02408", "1.17938"},
          {"13.00000", "310.52195", "0.97621", "6.37934", "1.15268", 
            "5.70455", "0.02595", "1.25286"},
          {"14.00000", "310.89584", "1.01507", "6.86661", "1.17266", 
            "6.09727", "0.02787", "1.32551"},
          {"15.00000", "311.25469", "1.05481", "7.35354", "1.19190", 
            "6.49112", "0.02985", "1.39737"},
          {"16.00000", "311.59980", "1.09538", "7.84014", "1.21047", 
            "6.88601", "0.03189", "1.46847"},
          {"17.00000", "311.93230", "1.13672", "8.32643", "1.22842", 
            "7.28188", "0.03398", "1.53885"},
          {"18.00000", "312.25319", "1.17877", "8.81242", "1.24579", 
            "7.67865", "0.03613", "1.60854"},
          {"19.00000", "312.56334", "1.22150", "9.29811", "1.26264", 
            "8.07629", "0.03833", "1.67756"},
          {"20.00000", "312.86353", "1.26485", "9.78353", "1.27899", 
            "8.47472", "0.04058", "1.74595"},
          {"21.00000", "313.15444", "1.30880", "10.26869", "1.29488", 
            "8.87391", "0.04288", "1.81371"},
          {"22.00000", "313.43669", "1.35331", "10.75358", "1.31034", 
            "9.27382", "0.04524", "1.88089"},
          {"23.00000", "313.71084", "1.39835", "11.23823", "1.32540", 
            "9.67440", "0.04764", "1.94749"},
          {"24.00000", "313.97738", "1.44390", "11.72264", "1.34008", 
            "10.07562", "0.05010", "2.01354"},
          {"25.00000", "315.92763", "3.77884", "15.76670", "1.44861", 
            "13.38941", "0.14841", "2.53696"},
          {"26.00000", "316.20183", "3.92014", "16.39267", "1.46403", 
            "13.91245", "0.15649", "2.61641"},
          {"27.00000", "316.46879", "4.06196", "17.01841", "1.47908", 
            "14.43615", "0.16469", "2.69518"},
          {"28.00000", "316.72891", "4.20428", "17.64393", "1.49379", 
            "14.96049", "0.17303", "2.77332"},
          {"29.00000", "316.98257", "4.34707", "18.26922", "1.50816", 
            "15.48544", "0.18150", "2.85083"},
          {"30.00000", "317.23010", "4.49032", "18.89431", "1.52222", 
            "16.01096", "0.19009", "2.92774"},
          {"31.00000", "317.47183", "4.63401", "19.51918", "1.53598", 
            "16.53703", "0.19880", "3.00406"},
          {"32.00000", "317.70802", "4.77811", "20.14385", "1.54946", 
            "17.06364", "0.20763", "3.07982"},
          {"33.00000", "317.93897", "4.92261", "20.76833", "1.56267", 
            "17.59075", "0.21658", "3.15503"},
          {"34.00000", "318.16490", "5.06749", "21.39261", "1.57562", 
            "18.11834", "0.22564", "3.22971"}
          },
        RowSpacings->0,
        ColumnSpacings->4,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #, TableSpacing -> {0, 4}]&)]], "Output",
  Evaluatable->False,
  LineSpacing->{1.25, 0},
  AspectRatioFixed->True,
  FontFamily->"Palatino"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 800}, {0, 580}},
AutoGeneratedPackage->Automatic,
WindowToolbars->{"RulerBar", "EditBar"},
CellGrouping->Automatic,
WindowSize->{634, 535},
WindowMargins->{{13, Automatic}, {Automatic, 8}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 301, 10, 148, "Title"],

Cell[CellGroupData[{
Cell[2057, 65, 113, 3, 50, "Section",
  InitializationCell->True],
Cell[2173, 70, 93, 2, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[2303, 77, 228, 8, 35, "Section"],
Cell[2534, 87, 163, 3, 41, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[2734, 95, 124, 2, 30, "Section"],
Cell[2861, 99, 254, 5, 110, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[3152, 109, 86, 2, 30, "Section"],

Cell[CellGroupData[{
Cell[3263, 115, 115, 2, 45, "Subsection"],
Cell[3381, 119, 216, 5, 88, "Input"],

Cell[CellGroupData[{
Cell[3622, 128, 116, 2, 40, "Subsubsection"],
Cell[3741, 132, 128, 3, 41, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3906, 140, 106, 2, 40, "Subsubsection"],

Cell[CellGroupData[{
Cell[4037, 146, 197, 4, 79, "Input"],
Cell[4237, 152, 54, 1, 26, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4352, 160, 101, 2, 45, "Subsection"],
Cell[4456, 164, 270, 6, 90, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4763, 175, 119, 2, 45, "Subsection"],
Cell[4885, 179, 119, 3, 56, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5053, 188, 98, 2, 50, "Section"],

Cell[CellGroupData[{
Cell[5176, 194, 91, 2, 70, "Subsection"],
Cell[5270, 198, 217, 5, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[5524, 208, 98, 2, 70, "Subsection"],

Cell[CellGroupData[{
Cell[5647, 214, 411, 10, 70, "Input"],
Cell[6061, 226, 218, 5, 70, "Message"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6328, 237, 98, 2, 70, "Subsection"],

Cell[CellGroupData[{
Cell[6451, 243, 419, 10, 70, "Input"],
Cell[6873, 255, 218, 5, 70, "Message"],
Cell[7094, 262, 222, 5, 70, "Message"],
Cell[7319, 269, 224, 5, 70, "Message"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7592, 280, 103, 2, 70, "Subsection"],

Cell[CellGroupData[{
Cell[7720, 286, 248, 5, 70, "Input"],
Cell[7971, 293, 134, 4, 70, "Output"],
Cell[8108, 299, 124, 4, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8281, 309, 105, 2, 70, "Subsection"],
Cell[8389, 313, 359, 8, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[8785, 326, 105, 2, 70, "Subsection"],
Cell[8893, 330, 422, 9, 70, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9364, 345, 99, 2, 30, "Section"],

Cell[CellGroupData[{
Cell[9488, 351, 103, 2, 45, "Subsection"],
Cell[9594, 355, 264, 8, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[9895, 368, 122, 2, 29, "Subsection"],
Cell[10020, 372, 668, 13, 284, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10725, 390, 103, 2, 45, "Subsection"],
Cell[10831, 394, 317, 6, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[11185, 405, 113, 2, 29, "Subsection"],
Cell[11301, 409, 138, 3, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[11476, 417, 106, 2, 29, "Subsection"],
Cell[11585, 421, 437, 8, 70, "Input"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12071, 435, 119, 2, 30, "Section"],

Cell[CellGroupData[{
Cell[12215, 441, 98, 2, 45, "Subsection"],
Cell[12316, 445, 127, 3, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[12480, 453, 95, 2, 29, "Subsection"],
Cell[12578, 457, 366, 7, 101, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12981, 469, 94, 2, 45, "Subsection"],

Cell[CellGroupData[{
Cell[13100, 475, 121, 3, 26, "Input"],
Cell[13224, 480, 4475, 82, 469, "Output"],
Cell[17702, 564, 4475, 82, 469, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

